<!-- REGISTER MODAL -->
<div class="modal fade" id="registerModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Register</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">

        @if($errors->any())
          <div class="alert alert-danger">
            @foreach($errors->all() as $error)
              <div>{{ $error }}</div>
            @endforeach
          </div>
        @endif

        @if(session('success'))
          <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if(session('error'))
          <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <form action="{{ route('registration_submit')}}" method="POST">
          @csrf

          <div class="mb-3">
            <label>Name:</label>
            <input type="text" class="form-control" name="name" placeholder="Name">
          </div>

          <div class="mb-3">
            <label>Email:</label>
            <input type="email" class="form-control" name="email" placeholder="Email">
          </div>

          <div class="mb-3">
            <label>Password:</label>
            <input type="password" class="form-control" name="password" placeholder="Password">
          </div>

          <div class="mb-3">
            <label>Confirm Password:</label>
            <input type="password" class="form-control" name="confirm_password" placeholder="Confirm Password">
          </div>

          <button type="submit" class="btn btn-success w-100">Register</button>
        </form>

        <!-- Switch to Login -->
        <p class="text-center mt-2">
          Already have an account? <a href="#" id="openLogin">Login</a>
        </p>

      </div>
    </div>
  </div>
</div>
<script>
document.getElementById('openLogin')?.addEventListener('click', function(){
    var registerModal = bootstrap.Modal.getInstance(document.getElementById('registerModal'));
    registerModal.hide();
    new bootstrap.Modal(document.getElementById('loginModal')).show();
});
</script>
@if($errors->any() && old('page') === 'register')
<script>
document.addEventListener("DOMContentLoaded", function(){
    new bootstrap.Modal(document.getElementById('registerModal')).show();
});
</script>
@endif
