@extends('layouts.app')

@section('title','Sculptures')

@section('content')
<div class="container py-5">

    <h2 class="text-center fw-bold mb-4">Sculpture Collection</h2><br>

    <div class="row g-4">
        @forelse($sculptures as $sculpture)
        <div class="col-6 col-md-4 col-lg-3">

            <div class="sculpture-card shadow-sm">

                <div class="sculpture-image">
                    <img src="{{ asset('uploads/sculptures/'.$sculpture->image) }}"
                         alt="{{ $sculpture->title }}">
                </div>

                <div class="sculpture-body text-center">
                    <h6 class="fw-bold">
                        {{ Str::limit($sculpture->title, 22) }}
                    </h6>

                    <p class="price mb-2">
                        ₹ {{ number_format((float) $sculpture->price, 0, '.', ',') }}
                    </p>

                    <a href="{{ route('sculpture.show',$sculpture->id) }}"
                       class="btn btn-danger btn-sm w-100">
                        View Details →
                    </a>
                </div>

            </div>

        </div>
        @empty
        <p class="text-center text-muted">No sculptures available.</p>
        @endforelse
    </div>

    <div class="mt-4">
        {{ $sculptures->links() }}
    </div>

</div>
@endsection

<style>
.sculpture-card{
    background:#fff;
    border-radius:10px;
    overflow:hidden;
    transition:.3s;
}
.sculpture-card:hover{
    transform:translateY(-5px);
}
.sculpture-image{
    height:240px;
    overflow:hidden;
}
.sculpture-image img{
    width:100%;
    height:100%;
    object-fit:cover;
}
.sculpture-body{
    padding:12px;
}
.price{
    font-size:16px;
    color:#148c2e;
    font-weight:600;
}

@media(max-width:576px){
    .sculpture-image{ height:180px; }
}
</style>
