@extends('layouts.app')

@section('title', $event->title)

@section('content')
<div class="container py-5">

    <!-- Top Section -->
   <div class="event-wrapper">

    <!-- Left Image -->
    <div class="event-image-box">
        <img src="{{ asset('uploads/events/'.$event->image) }}" alt="{{ $event->title }}">
    </div>

    <!-- Middle Info -->
    <div class="event-info-card">
        <h2 class="event-title">{{ $event->title }}</h2>

        <ul class="event-meta">
            <li><i class="fas fa-calendar-alt text-primary"></i>📅 {{ \Carbon\Carbon::parse($event->event_date)->format('d M, Y') }}</li>
            <li><i class="fas fa-clock text-warning"></i>⏰ {{ $event->event_time }}</li>
            <li><i class="fas fa-map-marker-alt text-danger"></i>📍 {{ $event->location }}</li>
        </ul>

        @if($event->link)
        <a href="{{ $event->link }}" class="event-btn-outline" target="_blank">Official Page →</a>
        @endif
    </div>

    <!-- Right Form -->
    <div class="event-form-card">
        <h4>Register for This Event</h4>

        <form action="" method="POST">
            @csrf
            <input type="text" name="name" placeholder="Full Name" required>
            <input type="email" name="email" placeholder="Email Address" required>
            <input type="text" name="phone" placeholder="Phone Number" required>
            <textarea name="message" placeholder="Message (Optional)"></textarea>

            <button type="submit" class="event-btn">Submit Registration</button>
        </form>
    </div>
</div>


    <!-- Divider -->
    <hr class="my-5">

    <!-- About The Event -->
    <div class="event-description">
        <h3 class="fw-semibold">About The Event</h3>
        <p class="mt-3" style="font-size:18px; line-height:1.7;">
            {!! $event->description !!}
        </p>
    </div>

    <!-- Map Section -->
    @if($event->map_embed)
    <hr class="my-5">
    <h3 class="fw-semibold mb-3">Venue Map</h3>
    <div class="ratio ratio-16x9">
        {!! $event->map_embed !!}
    </div>
    @endif

</div>
@endsection
<style>
    .event-wrapper {
    display: grid;
    grid-template-columns: 1.4fr 1fr 1.4fr;
    gap: 50px;
    align-items: center;
    margin-bottom: 50px;
}

/* Left Image */
.event-image-box img {
    width: 100%;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.12);
}

/* Middle Section */
.event-info-card {
    text-align: center;
}

.event-title {
    font-size: 30px;
    font-weight: 700;
    margin-bottom: 15px;
}

.event-meta {
    padding: 0;
    list-style: none;
    margin-bottom: 25px;
    font-size: 18px;
    line-height: 2;
}

.event-meta li i {
    margin-right: 8px;
}

/* Button */
.event-btn-outline {
    padding: 10px 20px;
    border: 2px solid #d31010;
    border-radius: 30px;
    text-decoration: none;
    font-weight: 600;
    transition: .3s;
    display: inline-block;
    margin-top: 10px;
}

.event-btn-outline:hover {
    background: #d31010;
    color: #fff;
}

/* Right Form */
.event-form-card {
    background: white;
    padding: 30px;
    border-radius: 18px;
    box-shadow: 0 10px 35px rgba(0,0,0,0.08);
}

.event-form-card h4 {
    font-weight: bold;
    color: #d31010;
    margin-bottom: 20px;
}

.event-form-card input,
.event-form-card textarea {
    width: 100%;
    padding: 12px;
    border-radius: 10px;
    border: 1px solid #ccc;
    margin-bottom: 12px;
    font-size: 15px;
}

.event-btn {
    width: 100%;
    background: #d31010;
    color: white;
    padding: 14px;
    border-radius: 50px;
    font-size: 16px;
    font-weight: bold;
    border: none;
    transition: .3s;
}

.event-btn:hover {
    background: black;
}

/* Responsive */
@media(max-width: 992px){
    .event-wrapper {
        grid-template-columns: 1fr;
        text-align: center;
        gap: 30px;
    }
}

</style>