@extends('layouts.app')

@section('title', 'Contact Us')

@section('content')

<section class="contact-section">
    <div class="site-inner">
        <div class="contact-head">
            <!-- <span class="contact-kicker">Contact</span>
            <h1>Let's Start The Conversation</h1>
            <p>
                Share your query and our team will get back with the right guidance on exhibitions,
                artists, acquisitions, and private viewings.
            </p> -->
        </div>

        @if (session('success'))
            <div class="contact-alert contact-alert-success">
                {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="contact-alert contact-alert-error">
                Please fix the highlighted fields and submit again.
            </div>
        @endif

        <div class="contact-grid">
            <div>
                <h3>Get In Touch</h3>
                <p>
                    Have a question about our captivating exhibitions, talented artists,
                    or exquisite artworks? Whether you're curious about upcoming shows,
                    artist inspirations, pricing, private viewings, or acquisitions,
                    we are here to help.
                </p>

                <ul class="info-list">
                    @if(!empty($contact?->address))
                        <li>
                            <span class="info-badge">Address</span>
                            <span class="info-text">{!! nl2br(e($contact->address)) !!}</span>
                        </li>
                    @endif

                    @if(!empty($contact?->phone))
                        <li>
                            <span class="info-badge">Phone</span>
                            <a class="info-link" href="tel:{{ preg_replace('/\s+/', '', $contact->phone) }}">{{ $contact->phone }}</a>
                        </li>
                    @endif

                    @if(!empty($contact?->email))
                        <li>
                            <span class="info-badge">Email</span>
                            <a class="info-link" href="mailto:{{ $contact->email }}">{{ $contact->email }}</a>
                        </li>
                    @endif
                </ul>
            </div>

            <div class="contact-form-card">
                <h4>Send Us A Message</h4>
                <p class="form-intro">Complete the form below and we will respond shortly.</p>

                <form method="POST" action="{{ route('contact.submit') }}">
                    @csrf

                    <div class="form-group">
                        <label for="name">Name</label>
                        <input id="name" type="text" name="name" value="{{ old('name') }}" required class="@error('name') is-invalid @enderror" placeholder="Your full name">
                        @error('name')
                            <small class="field-error">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="email">Email</label>
                        <input id="email" type="email" name="email" value="{{ old('email') }}" required class="@error('email') is-invalid @enderror" placeholder="you@example.com">
                        @error('email')
                            <small class="field-error">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="phone">Phone</label>
                        <input id="phone" type="text" name="phone" value="{{ old('phone') }}" class="@error('phone') is-invalid @enderror" placeholder="+91 98765 43210">
                        @error('phone')
                            <small class="field-error">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="message">Message</label>
                        <textarea id="message" name="message" rows="5" required class="@error('message') is-invalid @enderror" placeholder="How can we help you today?">{{ old('message') }}</textarea>
                        @error('message')
                            <small class="field-error">{{ $message }}</small>
                        @enderror
                    </div>

                    <button type="submit" class="submit-btn">Send Message</button>
                </form>
            </div>
        </div>
    </div>
</section>

@if(!empty($contact?->map_embed))
<section class="map-section">
    <div class="map-wrapper">
        {!! $contact->map_embed !!}
    </div>
</section>
@endif

@if(!empty($pageContents['contact']->content))
<section class="seo-content">
    <div class="site-inner">
        {!! html_entity_decode($pageContents['contact']->content) !!}
    </div>
</section>
@endif

@endsection

<style>
:root {
    --contact-primary: #819A91;
    --contact-primary-dark: #6f867e;
    --contact-surface: #ffffff;
    --contact-bg-soft: #f7faf8;
    --contact-text: #1f2624;
    --contact-muted: #606c68;
    --contact-border: #d9e3df;
}

.contact-section {
    padding: 40px 0 80px;
    background:
        radial-gradient(circle at 10% 10%, rgba(129,154,145,0.12), transparent 45%),
        radial-gradient(circle at 90% 90%, rgba(111,134,126,0.09), transparent 45%),
        #fff;
}

.contact-head {
    max-width: 760px;
    margin: 0 auto 44px;
    text-align: center;
}

.contact-kicker {
    display: inline-block;
    font-size: 12px;
    font-weight: 700;
    letter-spacing: 1.2px;
    text-transform: uppercase;
    color: var(--contact-primary-dark);
    background: rgba(129,154,145,0.14);
    border: 1px solid rgba(129,154,145,0.25);
    border-radius: 30px;
    padding: 7px 14px;
    margin-bottom: 14px;
}

.contact-head h1 {
    margin: 0 0 14px;
    color: var(--contact-text);
    font-size: 40px;
    font-weight: 700;
    line-height: 1.15;
}

.contact-head p {
    margin: 0;
    color: var(--contact-muted);
    font-size: 16px;
    line-height: 1.7;
}

.contact-alert {
    max-width: 760px;
    margin: 0 auto 24px;
    padding: 12px 16px;
    border-radius: 10px;
    border: 1px solid;
    font-size: 14px;
    font-weight: 500;
}

.contact-alert-success {
    color: #1f6d43;
    border-color: #b6e2c9;
    background: #e9f8ef;
}

.contact-alert-error {
    color: #9f2f2f;
    border-color: #f0b8b8;
    background: #fff1f1;
}

.contact-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 34px;
    align-items: start;
}

.contact-info {
    background: var(--contact-bg-soft);
    border: 1px solid var(--contact-border);
    border-radius: 18px;
    padding: 34px 30px;
}

.contact-info h3 {
    font-size: 28px;
    font-weight: 700;
    color: var(--contact-text);
    margin-bottom: 12px;
}

.contact-info p {
    font-size: 15px;
    color: var(--contact-muted);
    line-height: 1.7;
    margin-bottom: 24px;
}

.info-list {
    list-style: none;
    padding: 0;
    margin: 0;
    display: grid;
    gap: 12px;
}

.info-list li {
    display: grid;
    grid-template-columns: 90px 1fr;
    gap: 12px;
    align-items: start;
    background: #fff;
    border: 1px solid var(--contact-border);
    border-radius: 12px;
    padding: 12px;
    font-size: 15px;
}

.info-badge {
    display: inline-flex;
    justify-content: center;
    align-items: center;
    min-height: 34px;
    border-radius: 8px;
    font-size: 12px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.7px;
    color: var(--contact-primary-dark);
    background: rgba(129,154,145,0.12);
}

.info-text {
    color: #2a3330;
    line-height: 1.6;
}

.info-link {
    color: #2a3330;
    text-decoration: none;
    line-height: 1.6;
    word-break: break-word;
}

.info-link:hover {
    color: var(--contact-primary-dark);
}

.contact-form-card {
    background: var(--contact-surface);
    padding: 34px 30px;
    border-radius: 18px;
    border: 1px solid var(--contact-border);
    box-shadow: 0 18px 44px rgba(14, 26, 22, 0.1);
}

.contact-form-card h4 {
    margin: 0 0 6px;
    color: var(--contact-text);
    font-size: 24px;
    font-weight: 700;
}

.form-intro {
    margin: 0 0 20px;
    color: var(--contact-muted);
    font-size: 14px;
}

.form-group {
    margin-bottom: 16px;
}

.form-group label {
    font-size: 12px;
    font-weight: 600;
    letter-spacing: 0.5px;
    text-transform: uppercase;
    color: #4f5a56;
    margin-bottom: 7px;
    display: block;
}

.form-group input,
.form-group textarea {
    width: 100%;
    padding: 11px 14px;
    border: 1px solid var(--contact-border);
    border-radius: 10px;
    background: #fff;
    font-size: 14px;
    color: #1f2624;
    transition: border-color 0.25s ease, box-shadow 0.25s ease;
}

.form-group textarea {
    resize: vertical;
    min-height: 120px;
}

.form-group input:focus,
.form-group textarea:focus {
    border-color: var(--contact-primary);
    outline: none;
    box-shadow: 0 0 0 3px rgba(129,154,145,0.18);
}

.is-invalid {
    border-color: #d9534f !important;
    box-shadow: 0 0 0 3px rgba(217, 83, 79, 0.14) !important;
}

.field-error {
    display: inline-block;
    margin-top: 6px;
    color: #c0392b;
    font-size: 12px;
}

.submit-btn {
    width: 100%;
    margin-top: 4px;
    padding: 12px;
    background: linear-gradient(135deg, var(--contact-primary), var(--contact-primary-dark));
    color: #fff;
    border: none;
    border-radius: 30px;
    font-weight: 600;
    letter-spacing: 0.25px;
    cursor: pointer;
    transition: transform 0.22s ease, box-shadow 0.22s ease;
}

.submit-btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 10px 24px rgba(111,134,126,0.26);
}

.submit-btn:active {
    transform: translateY(0);
}

.map-section {
    margin-top: 64px;
}

.map-wrapper {
    width: 100%;
    height: 460px;
    overflow: hidden;
}

.map-wrapper iframe {
    width: 100%;
    height: 100%;
    border: 0;
    filter: saturate(0.9) contrast(1.05);
}

@media (max-width: 992px) {
    .contact-section {
        padding: 72px 0 60px;
    }

    .contact-head h1 {
        font-size: 34px;
    }

    .contact-grid {
        grid-template-columns: 1fr;
        gap: 24px;
    }

    .contact-info,
    .contact-form-card {
        padding: 26px 22px;
    }

    .map-section {
        margin-top: 48px;
    }

    .map-wrapper {
        height: 320px;
    }
}

@media (max-width: 576px) {
    .contact-section {
        padding: 5px 0 54px;
    }

    .contact-head {
        margin-bottom: 30px;
    }

    .contact-head h1 {
        font-size: 28px;
    }

    .contact-head p {
        font-size: 14px;
    }

    .contact-info h3 {
        font-size: 24px;
    }

    .info-list li {
        grid-template-columns: 1fr;
        gap: 8px;
    }

    .info-badge {
        justify-content: flex-start;
        padding: 0 10px;
    }

    .map-wrapper {
        height: 280px;
    }
}
</style>
