@extends('layouts.app')

@section('title', 'Artist Profile')

@section('content')
<div class="container py-5" style="max-width:600px;">

    <h3 class="mb-4">My Profile</h3>

    {{-- Success Message --}}
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    {{-- Profile Update Form --}}
    <form method="POST" action="{{ route('artist.profile.update') }}">
        @csrf

        <div class="mb-3">
            <label class="form-label fw-semibold">Name</label>
            <input type="text"
                   name="name"
                   value="{{ old('name', $artist->name) }}"
                   class="form-control @error('name') is-invalid @enderror">

            @error('name')
                <div class="invalid-feedback">{{ $message }}</div>
            @enderror
        </div>

        <div class="mb-3">
            <label class="form-label fw-semibold">Email</label>
            <input type="email"
                   value="{{ $artist->email }}"
                   class="form-control"
                   disabled>
        </div>

        <button class="btn btn-dark">
            Update Profile
        </button>

        <a href="{{ route('artist.password') }}"
           class="btn btn-link ms-3">
            Change Password
        </a>
    </form>

</div>
@endsection
