@extends('artist.layouts.app')

@section('title','My Artworks')

@section('content')

<div class="container-fluid">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">My Artworks</h4>

        <a href="{{ route('artist.paintings.create') }}" class="btn btn-dark">
            <i class="bi bi-plus-circle"></i> Add Artwork
        </a>
    </div>

    <!-- Success -->
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- Table -->
    <div class="card shadow-sm border-0">
        <div class="card-body p-0">

            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Code</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Form</th>
                        <th>Price</th>
                        <th>Updated By</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>

                <tbody>
                @forelse($paintings as $painting)
                    <tr>

                        <td class="text-primary fw-semibold">
                            {{ $painting->painting_code ?? '—' }}
                        </td>

                        <td>
                            @if($painting->image)
                                <img src="{{ asset('uploads/paintings/'.$painting->image) }}"
                                     style="width:60px;height:60px;object-fit:cover;border-radius:6px;">
                            @endif
                        </td>

                        <td class="fw-semibold">
                            {{ $painting->title }}
                        </td>

                        <td>
                            {{ $painting->form->name ?? '—' }}
                        </td>

                        <td>
                            ₹ {{ number_format($painting->price,2) }}
                        </td>

                        <td>
                            {{ $painting->updated_by ?? '—' }}
                        </td>

                        <td class="text-center">
                            <div class="d-flex justify-content-center gap-2">

                                <!-- Preview -->
                                <!-- @if($painting->image)
                                <button class="btn btn-sm btn-outline-secondary preview-btn"
                                        data-bs-toggle="modal"
                                        data-bs-target="#previewModal"
                                        data-image="{{ asset('uploads/paintings/'.$painting->image) }}"
                                        data-title="{{ $painting->title }}">
                                    <i class="bi bi-eye"></i>
                                </button>
                                @endif -->

                                <!-- Edit -->
                                <a href="{{ route('artist.paintings.edit',$painting) }}"
                                   class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil-square"></i>
                                </a>

                                <!-- Delete -->
                                <form action="{{ route('artist.paintings.destroy',$painting) }}"
                                      method="POST">
                                    @csrf
                                    @method('DELETE')

                                    <button class="btn btn-sm btn-outline-danger"
                                            onclick="return confirm('Delete artwork?')">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>

                            </div>
                        </td>

                    </tr>
                @empty
                    <tr>
                        <td colspan="7" class="text-center text-muted py-4">
                            No artworks found
                        </td>
                    </tr>
                @endforelse
                </tbody>

            </table>

        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-3">
        {{ $paintings->links() }}
    </div>

</div>

<!-- PREVIEW MODAL -->
<div class="modal fade" id="previewModal">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="previewTitle"></h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body text-center">
                <img id="previewImage"
                     class="img-fluid rounded"
                     style="max-height:70vh;">
            </div>

        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
document.querySelectorAll('.preview-btn').forEach(btn=>{
    btn.addEventListener('click',function(){
        previewImage.src = this.dataset.image;
        previewTitle.innerText = this.dataset.title;
    });
});
</script>
@endpush
