<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Artist Panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Bootstrap --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    {{-- Icons --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body { background:#f8f9fa; }

        .sidebar {
            width:240px;
            min-height:100vh;
            background:#111;
        }

        .sidebar a {
            color:#ccc;
            text-decoration:none;
            display:block;
            padding:12px 20px;
        }

        .sidebar a:hover,
        .sidebar a.active {
            background:#222;
            color:#fff;
        }

        .content {
            padding:25px;
        }

        .avatar {
            width:36px;
            height:36px;
            border-radius:50%;
            background:#000;
            color:#fff;
            display:flex;
            align-items:center;
            justify-content:center;
            cursor:pointer;
        }
    </style>
</head>

<body>

{{-- HEADER --}}
<nav class="navbar bg-white border-bottom px-4">
    <span class="fw-bold">@yield('title','Artist Panel')</span>

    <div class="dropdown">
        <div class="avatar dropdown-toggle" data-bs-toggle="dropdown">
            {{ strtoupper(substr(auth('artist')->user()->name ?? 'A',0,1)) }}
        </div>

        <ul class="dropdown-menu dropdown-menu-end">

            <li>
                <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#profileModal">
                    <i class="bi bi-person"></i> Profile
                </a>
            </li>

            <li><hr class="dropdown-divider"></li>

            <li>
                <a class="dropdown-item text-danger" href="{{ route('artist.logout') }}">
                    <i class="bi bi-box-arrow-right"></i> Logout
                </a>
            </li>

        </ul>
    </div>
</nav>

<div class="d-flex">

    {{-- SIDEBAR --}}
    <div class="sidebar">

        <!-- <a href="{{ route('artist.dashboard') }}"
           class="{{ request()->routeIs('artist.dashboard') ? 'active' : '' }}">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a> -->

        <a href="{{ route('artist.paintings.index') }}"
           class="{{ request()->routeIs('artist.paintings.*') ? 'active' : '' }}">
            <i class="bi bi-palette"></i> Artworks
        </a>

    </div>

    {{-- CONTENT --}}
    <div class="flex-grow-1 content">
        @yield('content')
    </div>

</div>

{{-- PROFILE MODAL --}}
<div class="modal fade" id="profileModal">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">Profile Settings</h5>
                <button class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">

                {{-- PROFILE UPDATE --}}
                <form method="POST" action="{{ route('artist.profile.update') }}">
                    @csrf

                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name"
                               value="{{ auth('artist')->user()->name }}"
                               class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Email</label>
                        <input type="email" name="email"
                               value="{{ auth('artist')->user()->email }}"
                               class="form-control">
                    </div>

                    <button class="btn btn-dark w-100 mb-3">
                        Save Profile
                    </button>
                </form>

                {{-- PASSWORD UPDATE --}}
                <form method="POST" action="{{ route('artist.password.update') }}">
                    @csrf

                    <div class="mb-3">
                        <label>New Password</label>
                        <input type="password" name="password" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label>Confirm Password</label>
                        <input type="password" name="password_confirmation" class="form-control">
                    </div>

                    <button class="btn btn-warning w-100">
                        Change Password
                    </button>
                </form>

            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
