@extends('layouts.app')

@section('title', 'Change Password')

@section('content')
<div class="container py-5" style="max-width:600px;">

    <h3 class="mb-4">Change Password</h3>

    {{-- Success Message --}}
    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    {{-- Error Message --}}
    @if($errors->any())
        <div class="alert alert-danger">
            {{ $errors->first() }}
        </div>
    @endif

    <form method="POST" action="{{ route('artist.password.update') }}">
        @csrf

        <!-- Current Password -->
        <div class="mb-3">
            <label class="form-label fw-semibold">Current Password</label>
            <input type="password"
                   name="current_password"
                   class="form-control">
        </div>

        <!-- New Password -->
        <div class="mb-3">
            <label class="form-label fw-semibold">New Password</label>
            <input type="password"
                   name="password"
                   class="form-control">
        </div>

        <!-- Confirm Password -->
        <div class="mb-4">
            <label class="form-label fw-semibold">Confirm New Password</label>
            <input type="password"
                   name="password_confirmation"
                   class="form-control">
        </div>

        <button class="btn btn-dark">
            Update Password
        </button>

        <a href="{{ route('artist.dashboard') }}"
           class="btn btn-link ms-3">
            Back to Dashboard
        </a>
    </form>

</div>
@endsection
