@extends('admin.layout')

@section('title', 'SEO Pages')

@section('content')
<style>
.seo-page-admin {
    --seo-accent: #e6732c;
    --seo-border: #e4e8f1;
    --seo-text: #1f2937;
    --seo-muted: #6b7280;
}

.seo-page-admin .seo-head {
    padding: 1.1rem 1.35rem;
    border-radius: 16px;
    background: linear-gradient(140deg, #fff7ef 0%, #ffffff 65%, #fff4ea 100%);
    border: 1px solid #f3d4ba;
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.08);
}

.seo-page-admin .seo-kicker {
    margin: 0 0 .25rem 0;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .11em;
    color: var(--seo-accent);
    font-weight: 700;
}

.seo-page-admin .seo-title {
    margin: 0;
    font-size: 1.7rem;
    color: var(--seo-text);
    font-weight: 700;
}

.seo-page-admin .table-card {
    border-radius: 18px;
    border: 1px solid var(--seo-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.seo-page-admin .table-card-header {
    padding: 1rem 1.2rem;
    border-bottom: 1px solid #edf1f7;
    background: #fbfcff;
}

.seo-page-admin .table-wrap {
    overflow-x: auto;
}

.seo-page-admin table {
    width: 100%;
    border-collapse: collapse;
    min-width: 900px;
}

.seo-page-admin thead th {
    padding: .85rem 1rem;
    font-size: .75rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    color: #5a6880;
    background: #f5f8fd;
    border-bottom: 1px solid #e7edf6;
}

.seo-page-admin tbody td {
    padding: .95rem 1rem;
    border-bottom: 1px solid #edf1f7;
    color: var(--seo-text);
    vertical-align: middle;
}

.seo-page-admin .slug-chip {
    display: inline-block;
    border: 1px solid #dbe3f2;
    border-radius: 999px;
    padding: .2rem .55rem;
    background: #f8fbff;
    font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
    font-size: .78rem;
}

.seo-page-admin .edit-btn {
    border: 0;
    border-radius: 8px;
    padding: .4rem .72rem;
    font-size: .78rem;
    font-weight: 600;
    color: #fff;
    background: #2563eb;
    text-decoration: none;
}

.seo-page-admin .edit-btn:hover {
    color: #fff;
    background: #1d4ed8;
}
</style>

<div class="seo-page-admin">
    <div class="seo-head mb-4">
        <p class="seo-kicker">Admin Panel</p>
        <h2 class="seo-title">SEO Pages</h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <div class="table-card">
        <div class="table-card-header">
            <strong style="color:#334155;">Static SEO Page Configuration</strong>
        </div>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th>Page Name</th>
                        <th>SEO Title</th>
                        <th>SEO Slug</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($seoPages as $page)
                        <tr>
                            <td>{{ $pageLabels[$page->page_key] ?? \Illuminate\Support\Str::headline($page->page_key) }}</td>
                            <td>{{ $page->seo_title }}</td>
                            <td><span class="slug-chip">{{ $page->seo_slug }}</span></td>
                            <td>
                                <a href="{{ route('admin.seo-pages.edit', $page->page_key) }}" class="edit-btn">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center text-muted">No SEO pages found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
