@extends('admin.layout')

@section('content')

<style>
.popular-search-page .page-head {
    padding: 1.1rem 1.25rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.popular-search-page .kicker {
    margin: 0 0 .2rem;
    font-size: .73rem;
    font-weight: 700;
    letter-spacing: .11em;
    text-transform: uppercase;
    color: #d97706;
}

.popular-search-page .title {
    margin: 0;
    font-size: 1.5rem;
    font-weight: 700;
    color: #1f2937;
}

.popular-search-page .table-card {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
    background: #fff;
}

.popular-search-page .table-wrap {
    overflow-x: auto;
}

.popular-search-page table {
    width: 100%;
    min-width: 860px;
    border-collapse: collapse;
}

.popular-search-page thead th {
    background: #f5f8fd;
    color: #52607a;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    padding: .85rem 1rem;
    border-bottom: 1px solid #e7edf6;
}

.popular-search-page tbody td {
    padding: .9rem 1rem;
    border-bottom: 1px solid #edf1f7;
    vertical-align: middle;
    color: #1f2937;
}

.popular-search-page tbody tr:hover {
    background: #fbfdff;
}

.popular-search-page .url-cell {
    max-width: 380px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.popular-search-page .btn-edit {
    border: 0;
    border-radius: 8px;
    padding: .38rem .72rem;
    font-size: .75rem;
    font-weight: 600;
    color: #fff;
    text-decoration: none;
    background: #2563eb;
}

.popular-search-page .btn-edit:hover {
    color: #fff;
    background: #1d4ed8;
}
</style>

<div class="container-fluid popular-search-page">

    <div class="page-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h4 class="title">Popular Searches</h4>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <strong style="color:#334155;">All Popular Searches</strong>

        <a href="{{ route('admin.popular-searches.create') }}"
           class="btn btn-primary">
            <i class="fa fa-plus"></i> Add New
        </a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @php
        $rows = $searches ?? $popularSearches ?? collect();
        $serialStart = method_exists($rows, 'firstItem')
            ? ($rows->firstItem() ?? 1)
            : 1;
    @endphp

    <div class="table-card">
        <div class="table-wrap">
            <table>
                <thead class="table-light">
                    <tr>
                        <th style="width: 90px;">S.NO.</th>
                        <th>Search Text</th>
                        <th>URL</th>
                        <th style="width: 120px;">Sort Order</th>
                        <th style="width: 120px;">Status</th>
                        <th style="width: 120px;">Actions</th>
                    </tr>
                </thead>
                <tbody>

                @forelse($rows as $search)
                    <tr>
                        <td>{{ $serialStart + $loop->index }}</td>

                        <td>
                            <strong>{{ $search->title }}</strong>
                        </td>

                        <td>
                            <small class="text-muted d-block url-cell" title="{{ $search->url ?? $search->link }}">
                                {{ $search->url ?? $search->link ?? '-' }}
                            </small>
                        </td>

                        <td>{{ $search->sort_order }}</td>

                        <td>
                            @if($search->status)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>

                        <td>
                            <a href="{{ route('admin.popular-searches.edit', $search->id) }}"
                               class="btn-edit">Edit</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted">
                            No popular searches found.
                        </td>
                    </tr>
                @endforelse

                </tbody>
            </table>
        </div>
    </div>

    @if(method_exists($rows, 'links'))
        <div class="d-flex justify-content-center mt-3">
            {{ $rows->links('pagination::bootstrap-5') }}
        </div>
    @endif

</div>

@endsection
