@extends('admin.layout')

@section('content')
<style>
.popular-search-edit .danger-card {
    border: 1px solid #fecaca;
    border-radius: 14px;
    background: #fff5f5;
}

.popular-search-edit .danger-btn {
    border: 0;
    border-radius: 10px;
    padding: .52rem .9rem;
    font-size: .82rem;
    font-weight: 600;
    color: #fff;
    background: linear-gradient(135deg, #dc2626 0%, #ef4444 100%);
}

.popular-search-edit .danger-btn:hover {
    background: linear-gradient(135deg, #b91c1c 0%, #dc2626 100%);
}
</style>

<div class="container popular-search-edit">
    <h3 class="mb-4">Edit Popular Search</h3>

    @if ($errors->any())
        <div class="alert alert-danger">
            @foreach ($errors->all() as $error)
                <div>{{ $error }}</div>
            @endforeach
        </div>
    @endif

    <form action="{{ route('admin.popular-searches.update', $popular_search->id) }}"
          method="POST">

        @csrf
        @method('PUT')

        <!-- TITLE -->
        <div class="mb-3">
            <label class="form-label">Search Title</label>
            <input type="text"
                   name="title"
                   class="form-control"
                   value="{{ old('title', $popular_search->title) }}"
                   required>
        </div>

        <!-- URL -->
        <div class="mb-3">
            <label class="form-label">URL (optional)</label>
            <input type="text"
                   name="url"
                   class="form-control"
                   value="{{ old('url', $popular_search->url) }}">
        </div>

        <!-- SORT ORDER -->
        <div class="mb-3">
            <label class="form-label">Sort Order</label>
            <input type="number"
                   name="sort_order"
                   class="form-control"
                   value="{{ old('sort_order', $popular_search->sort_order) }}">
        </div>

        <!-- STATUS -->
        <div class="mb-3">
            <label class="form-label">Status</label>
            <select name="status" class="form-select">
                <option value="1" {{ $popular_search->status ? 'selected' : '' }}>
                    Active
                </option>
                <option value="0" {{ !$popular_search->status ? 'selected' : '' }}>
                    Inactive
                </option>
            </select>
        </div>

        <button class="btn btn-primary">
            Update Popular Search
        </button>

        <a href="{{ route('admin.popular-searches.index') }}"
           class="btn btn-secondary">
            Back
        </a>
    </form>

    <div class="card danger-card mt-3">
        <div class="card-body d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-2">
            <div>
                <strong class="text-danger">Danger Zone</strong>
                <p class="mb-0 text-muted">Delete this popular search permanently.</p>
            </div>
            <form action="{{ route('admin.popular-searches.destroy', $popular_search->id) }}"
                  method="POST"
                  onsubmit="return confirm('Delete this popular search permanently?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="danger-btn">Delete</button>
            </form>
        </div>
    </div>
</div>

@endsection
