@extends('admin.layout')

@section('content')
<style>
/* Premium admin visual layer for Hero listing (no backend changes). */
.hero-admin-shell {
    --hero-accent: #e6732c;
    --hero-accent-dark: #cf5f1d;
    --hero-border: #e8edf4;
    --hero-text: #1f2937;
    --hero-muted: #6b7280;
}

.hero-hero {
    border-radius: 18px;
    border: 1px solid #f4d5bf;
    background: linear-gradient(130deg, #fff8f2 0%, #ffffff 58%, #fff1e6 100%);
    box-shadow: 0 16px 38px rgba(15, 23, 42, 0.08);
    padding: 18px 20px;
}

.hero-kicker {
    margin: 0 0 4px;
    text-transform: uppercase;
    letter-spacing: .12em;
    font-size: .74rem;
    font-weight: 700;
    color: var(--hero-accent);
}

.hero-title {
    margin: 0;
    color: var(--hero-text);
    font-weight: 700;
}

.hero-subtitle {
    margin: 6px 0 0;
    color: var(--hero-muted);
    font-size: .95rem;
}

.hero-btn-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--hero-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
    box-shadow: 0 14px 24px rgba(230, 115, 44, 0.22);
}

.hero-btn-primary:hover {
    background: linear-gradient(135deg, var(--hero-accent-dark) 0%, var(--hero-accent) 100%);
    color: #fff;
}

.hero-card {
    border-radius: 18px;
    border: 1px solid var(--hero-border);
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.06);
    overflow: hidden;
    background: #fff;
}

.hero-table {
    margin-bottom: 0;
}

.hero-table thead th {
    border-bottom: 1px solid #e9edf5;
    background: #f8fafc;
    color: #3a475a;
    font-size: .78rem;
    letter-spacing: .08em;
    text-transform: uppercase;
    font-weight: 700;
    white-space: nowrap;
}

.hero-table tbody td {
    border-color: #f2f4f8;
    vertical-align: middle;
}

.hero-thumb {
    width: 90px;
    height: 54px;
    border-radius: 10px;
    object-fit: cover;
    border: 1px solid #e5e7eb;
    background: #fff;
}

.hero-name {
    font-weight: 600;
    color: var(--hero-text);
}

.hero-status {
    display: inline-block;
    font-size: .74rem;
    font-weight: 700;
    border-radius: 999px;
    padding: 4px 9px;
}

.hero-status.active {
    background: #dcfce7;
    color: #166534;
}

.hero-status.inactive {
    background: #eceff3;
    color: #475569;
}

.hero-action {
    border-radius: 10px;
    font-weight: 600;
    min-width: 70px;
}

.hero-empty {
    color: #6b7280;
    text-align: center;
    padding: 42px 12px;
}
</style>

<div class="hero-admin-shell container-fluid py-4">
    <div class="hero-hero mb-4 d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
            <p class="hero-kicker">Homepage Settings</p>
            <h2 class="hero-title">Hero Slides</h2>
            <p class="hero-subtitle">Manage primary homepage slides and sequence order.</p>
        </div>

        <a href="{{ route('admin.hero.create') }}" class="btn hero-btn-primary px-4">Add Slide</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success border-0 shadow-sm">{{ session('success') }}</div>
    @endif

    @if($errors->any())
        <div class="alert alert-danger border-0 shadow-sm">
            <strong>Please fix the following:</strong>
            <ul class="mb-0 mt-2">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="hero-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle hero-table">
                <thead>
                    <tr>
                        <th class="ps-3">Order</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>Updated By</th>
                        <th>Status</th>
                        <th class="text-end pe-3" style="width: 120px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($sliders as $slide)
                        <tr>
                            <td class="ps-3">{{ $slide->sort_order }}</td>
                            <td>
                                <img src="{{ asset('uploads/hero/'.$slide->image) }}" class="hero-thumb" alt="{{ $slide->title }}">
                            </td>
                            <td><span class="hero-name">{{ $slide->title }}</span></td>
                            <td>{{ $slide->updated_by ?: '-' }}</td>
                            <td>
                                <span class="hero-status {{ $slide->status === 'active' ? 'active' : 'inactive' }}">
                                    {{ ucfirst($slide->status) }}
                                </span>
                            </td>
                            <td class="text-end pe-3">
                                {{-- List action intentionally only Edit; delete is available on edit screen. --}}
                                <a href="{{ route('admin.hero.edit', $slide->id) }}" class="btn btn-sm btn-outline-primary hero-action">Edit</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="hero-empty">No hero slides found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
