@extends('admin.layout')

@section('content')
<style>
.hero-edit-shell {
    --hero-accent: #e6732c;
    --hero-accent-dark: #cf5f1d;
    --hero-border: #e8edf4;
    --hero-text: #1f2937;
}

.hero-edit-card {
    max-width: 760px;
    margin: 0 auto;
    border-radius: 18px;
    border: 1px solid var(--hero-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.hero-edit-head {
    padding: 16px 20px;
    background: linear-gradient(120deg, #fff8f2 0%, #fff 70%);
    border-bottom: 1px solid #edf1f7;
}

.hero-edit-head h2 {
    margin: 0;
    color: var(--hero-text);
    font-size: 1.4rem;
    font-weight: 700;
}

.hero-edit-body {
    padding: 18px 20px;
}

.hero-edit-body label {
    font-size: .78rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    font-weight: 700;
    color: #4b5a72;
    margin-bottom: .4rem;
}

.hero-edit-body .form-control,
.hero-edit-body .form-select {
    min-height: 44px;
    border-radius: 12px;
    border: 1px solid #d9e0eb;
}

.hero-edit-body .form-control:focus,
.hero-edit-body .form-select:focus {
    border-color: #ebb387;
    box-shadow: 0 0 0 .25rem rgba(230, 115, 44, 0.12);
}

.hero-preview {
    width: 180px;
    border-radius: 10px;
    border: 1px solid #e5e7eb;
    object-fit: cover;
}

.btn-hero-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--hero-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
}

.btn-hero-primary:hover {
    background: linear-gradient(135deg, var(--hero-accent-dark) 0%, var(--hero-accent) 100%);
    color: #fff;
}

.hero-actions {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
    justify-content: space-between;
}
</style>

<div class="hero-edit-shell container-fluid py-4">
    <div class="hero-edit-card">
        <div class="hero-edit-head d-flex justify-content-between align-items-center">
            <h2>Edit Hero Slide</h2>
            <a href="{{ route('admin.hero.index') }}" class="btn btn-light">Back</a>
        </div>

        <form action="{{ route('admin.hero.update', $slide->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            <div class="hero-edit-body">
                <div class="mb-3">
                    <label>Title</label>
                    <input type="text" name="title" value="{{ $slide->title }}" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label>Subtitle</label>
                    <input type="text" name="subtitle" value="{{ $slide->subtitle }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label>Button Text</label>
                    <input type="text" name="button_text" value="{{ $slide->button_text }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label>Button Link</label>
                    <input type="text" name="button_link" value="{{ $slide->button_link }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label>Current Image</label><br>
                    <img src="{{ asset('uploads/hero/'.$slide->image) }}" class="hero-preview" alt="Current hero image">
                </div>

                <div class="mb-3">
                    <label>Change Image (1350 x 884)</label>
                    <input type="file" name="image" class="form-control" accept="image/*">
                </div>

                <div class="mb-3">
                    <label>Status</label>
                    <select name="status" class="form-select">
                        <option value="active" {{ $slide->status=='active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ $slide->status=='inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" value="{{ $slide->sort_order }}" class="form-control">
                </div>

                <div class="mb-4">
                    <label>Updated By</label>
                    <input type="text" name="updated_by" value="{{ $slide->updated_by }}" class="form-control">
                </div>

                <div class="hero-actions">
                    {{-- Delete is intentionally available only on edit screen as requested. --}}
                    <button type="button" class="btn btn-outline-danger" onclick="deleteHeroSlide()">Delete</button>

                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.hero.index') }}" class="btn btn-light">Cancel</a>
                        <button type="submit" class="btn btn-hero-primary px-4">Update Slide</button>
                    </div>
                </div>
            </div>
        </form>

        <form id="deleteHeroForm" action="{{ route('admin.hero.destroy', $slide->id) }}" method="POST" style="display:none;">
            @csrf
            @method('DELETE')
        </form>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteHeroSlide() {
    if (confirm('Delete this slide?')) {
        document.getElementById('deleteHeroForm').submit();
    }
}
</script>
@endpush
