@extends('admin.layout')

@section('content')
<style>
.hero-create-shell {
    --hero-accent: #e6732c;
    --hero-accent-dark: #cf5f1d;
    --hero-border: #e8edf4;
    --hero-text: #1f2937;
}

.hero-create-card {
    max-width: 760px;
    margin: 0 auto;
    border-radius: 18px;
    border: 1px solid var(--hero-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.hero-create-head {
    padding: 16px 20px;
    background: linear-gradient(120deg, #fff8f2 0%, #fff 70%);
    border-bottom: 1px solid #edf1f7;
}

.hero-create-head h2 {
    margin: 0;
    color: var(--hero-text);
    font-size: 1.4rem;
    font-weight: 700;
}

.hero-create-body {
    padding: 18px 20px;
}

.hero-create-body label {
    font-size: .78rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    font-weight: 700;
    color: #4b5a72;
    margin-bottom: .4rem;
}

.hero-create-body .form-control,
.hero-create-body .form-select {
    min-height: 44px;
    border-radius: 12px;
    border: 1px solid #d9e0eb;
}

.hero-create-body .form-control:focus,
.hero-create-body .form-select:focus {
    border-color: #ebb387;
    box-shadow: 0 0 0 .25rem rgba(230, 115, 44, 0.12);
}

.hero-help-note {
    color: #6b7280;
    font-size: .78rem;
}

.btn-hero-primary {
    border: none;
    border-radius: 12px;
    background: linear-gradient(135deg, var(--hero-accent) 0%, #f09552 100%);
    color: #fff;
    font-weight: 600;
}

.btn-hero-primary:hover {
    background: linear-gradient(135deg, var(--hero-accent-dark) 0%, var(--hero-accent) 100%);
    color: #fff;
}
</style>

<div class="hero-create-shell container-fluid py-4">
    <div class="hero-create-card">
        <div class="hero-create-head d-flex justify-content-between align-items-center">
            <h2>Add Hero Slide</h2>
            <a href="{{ route('admin.hero.index') }}" class="btn btn-light">Back</a>
        </div>

        @if ($errors->any())
            <div class="alert alert-danger border-0 m-3 mb-0 shadow-sm">
                <strong>Please fix the following:</strong>
                <ul class="mb-0 mt-2">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.hero.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="hero-create-body">
                <div class="mb-3">
                    <label>Title</label>
                    <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                </div>

                <div class="mb-3">
                    <label>Subtitle</label>
                    <input type="text" name="subtitle" class="form-control" value="{{ old('subtitle') }}">
                </div>

                <div class="mb-3">
                    <label>Button Text</label>
                    <input type="text" name="button_text" class="form-control" value="{{ old('button_text') }}">
                </div>

                <div class="mb-3">
                    <label>Button Link</label>
                    <input type="text" name="button_link" class="form-control" value="{{ old('button_link') }}">
                </div>

                <div class="mb-3">
                    <label>Slide Image (1350 x 884)</label>
                    <input type="file" name="image" class="form-control" accept="image/*" required>
                    <p class="hero-help-note mb-0 mt-1">Use high quality landscape image for best output.</p>
                </div>

                <div class="mb-3">
                    <label>Status</label>
                    <select name="status" class="form-select">
                        <option value="active" {{ old('status', 'active') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ old('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>

                <div class="mb-3">
                    <label>Sort Order</label>
                    <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 0) }}">
                </div>

                <div class="mb-4">
                    <label>Updated By</label>
                    <input type="text" name="updated_by" class="form-control" value="{{ old('updated_by') }}" placeholder="Enter name manually">
                </div>

                <div class="d-flex gap-2 justify-content-end">
                    <a href="{{ route('admin.hero.index') }}" class="btn btn-light">Cancel</a>
                    <button type="submit" class="btn btn-hero-primary px-4">Save Slide</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
