@extends('admin.layout')

@section('content')
<style>
.dashboard-shell {
    --dash-accent: #e6732c;
    --dash-ink: #1f2937;
    --dash-muted: #6b7280;
    --dash-border: #e5e7eb;
}

.dashboard-hero {
    background: linear-gradient(130deg, #fff8f2 0%, #ffe6d4 38%, #fff 100%);
    border: 1px solid #ffd7bf;
    border-radius: 18px;
    padding: 20px;
    box-shadow: 0 10px 24px rgba(230, 115, 44, 0.12);
}

.hero-title {
    margin: 0;
    color: var(--dash-ink);
    font-weight: 700;
}

.hero-subtitle {
    margin: 6px 0 0;
    color: var(--dash-muted);
}

.quick-actions {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.quick-actions .btn {
    border-radius: 999px;
    font-weight: 500;
    padding: 8px 14px;
}

.stat-card {
    position: relative;
    overflow: hidden;
    border: 1px solid var(--dash-border);
    border-radius: 16px;
    background: #fff;
    padding: 18px;
    height: 100%;
    box-shadow: 0 8px 20px rgba(15, 23, 42, 0.06);
    transition: transform .25s ease, box-shadow .25s ease;
}

.stat-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.12);
}

.stat-card .icon {
    width: 42px;
    height: 42px;
    border-radius: 12px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 18px;
}

.stat-card .count {
    font-size: 30px;
    font-weight: 700;
    color: var(--dash-ink);
    line-height: 1;
}

.stat-card .label {
    color: var(--dash-muted);
    margin-top: 4px;
    font-size: 14px;
}

.stat-card .link {
    margin-top: 10px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    text-decoration: none;
    font-weight: 600;
}

.card-artworks .icon { background: linear-gradient(135deg, #fb923c, #ea580c); }
.card-artists .icon { background: linear-gradient(135deg, #60a5fa, #2563eb); }
.card-admins .icon { background: linear-gradient(135deg, #34d399, #059669); }

.surface-card {
    border: 1px solid var(--dash-border);
    border-radius: 16px;
    background: #fff;
    padding: 18px;
    box-shadow: 0 8px 22px rgba(15, 23, 42, 0.06);
    height: 100%;
}

.surface-title {
    margin: 0 0 12px;
    font-size: 18px;
    font-weight: 600;
    color: var(--dash-ink);
}

.pulse-list {
    margin: 0;
    padding: 0;
    list-style: none;
    display: grid;
    gap: 10px;
}

.pulse-list li {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: 1px dashed #e7e7e7;
    border-radius: 10px;
    padding: 10px 12px;
    color: var(--dash-ink);
    font-size: 14px;
}

.pulse-list .status {
    font-size: 12px;
    padding: 4px 9px;
    border-radius: 999px;
    font-weight: 600;
}

.status-ok { background: #dcfce7; color: #166534; }
.status-mid { background: #ffedd5; color: #9a3412; }
.status-low { background: #fee2e2; color: #991b1b; }

.slider-wrap {
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 10px 24px rgba(15, 23, 42, 0.12);
    border: 1px solid #f1f1f1;
}

#paintingSlider {
    width: 100%;
    height: 320px;
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    animation: fadeSlide 0.9s ease;
}

@keyframes fadeSlide {
    from { opacity: 0.2; transform: scale(1.02); }
    to { opacity: 1; transform: scale(1); }
}

@media (max-width: 991px) {
    #paintingSlider { height: 240px; }
}
</style>

<div class="dashboard-shell container-fluid px-0">
    <div class="dashboard-hero mb-4 d-flex flex-column flex-lg-row align-items-lg-center justify-content-between gap-3">
        <div>
            <h2 class="hero-title">Admin Dashboard</h2>
            <p class="hero-subtitle">Overview of artworks, artists, exclusives, and engagement health.</p>
        </div>

        <div class="quick-actions">
            <a class="btn btn-outline-dark" href="{{ route('admin.paintings.index') }}"><i class="fa fa-paintbrush me-1"></i> Artworks</a>
            <a class="btn btn-outline-dark" href="{{ route('admin.artists.index') }}"><i class="fa fa-user me-1"></i> Artists</a>
            <a class="btn btn-outline-dark" href="{{ route('admin.blogs.index') }}"><i class="fa fa-blog me-1"></i> Blogs</a>
            <a class="btn btn-warning text-white" href="{{ route('admin.exhibitions.index') }}"><i class="fa fa-calendar-days me-1"></i> Exclusive</a>
        </div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md-6 col-xl-4">
            <div class="stat-card card-artworks">
                <span class="icon"><i class="fa fa-image"></i></span>
                <div class="count mt-3">{{ $paintingCount }}</div>
                <div class="label">Total Artworks</div>
                <a class="link text-warning-emphasis" href="{{ route('admin.paintings.index') }}">Manage artworks <i class="fa fa-arrow-right"></i></a>
            </div>
        </div>

        <div class="col-md-6 col-xl-4">
            <div class="stat-card card-artists">
                <span class="icon"><i class="fa fa-users"></i></span>
                <div class="count mt-3">{{ $artistCount }}</div>
                <div class="label">Total Artists</div>
                <a class="link text-primary-emphasis" href="{{ route('admin.artists.index') }}">View artists <i class="fa fa-arrow-right"></i></a>
            </div>
        </div>

        <div class="col-md-6 col-xl-4">
            <div class="stat-card card-admins">
                <span class="icon"><i class="fa fa-calendar-days"></i></span>
                <div class="count mt-3">{{ $exclusiveCount }}</div>
                <div class="label">Exclusives</div>
                <a class="link text-success-emphasis" href="{{ route('admin.exhibitions.index') }}">Manage exclusives <i class="fa fa-arrow-right"></i></a>
            </div>
        </div>
    </div>

    <!-- <div class="row g-3 mb-4">
        <div class="col-lg-8">
            <div class="surface-card">
                <h4 class="surface-title">Visitors Overview</h4>
                <canvas id="visitorsChart" height="130"></canvas>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="surface-card h-100">
                <h4 class="surface-title">Traffic Sources</h4>
                <canvas id="trafficChart" height="170"></canvas>
            </div>
        </div>
    </div> -->

    <div class="row g-3 mb-4">
        <div class="col-lg-7">
            <div class="surface-card">
                <h4 class="surface-title">Blog Category Performance</h4>
                <canvas id="categoryChart" height="120"></canvas>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="surface-card h-100">
                <h4 class="surface-title">Site Pulse</h4>
                <ul class="pulse-list">
                    <li><span>Pending contact replies</span><span class="status status-mid">12</span></li>
                    <li><span>New artwork submissions</span><span class="status status-ok">8</span></li>
                    <li><span>Low stock highlights</span><span class="status status-low">3</span></li>
                    <li><span>Draft blog posts</span><span class="status status-mid">5</span></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- <div class="slider-wrap">
        <div id="paintingSlider"></div>
    </div> -->
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    const paintings = [
        "{{ asset('uploads/users/1.png') }}",
        "{{ asset('uploads/users/2.png') }}",
        "{{ asset('uploads/users/3.png') }}"
    ];

    let index = 0;

    function changePainting() {
        const slider = document.getElementById("paintingSlider");
        if (!slider) return;

        slider.style.animation = "none";
        void slider.offsetWidth;
        slider.style.animation = "fadeSlide 0.9s ease";
        slider.style.backgroundImage = `url('${paintings[index]}')`;
        index = (index + 1) % paintings.length;
    }

    changePainting();
    setInterval(changePainting, 3200);

    new Chart(document.getElementById("visitorsChart"), {
        type: "line",
        data: {
            labels: ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"],
            datasets: [{
                label: "Visitors",
                data: [1200, 1350, 1420, 1600, 1750, 1900, 2080],
                borderColor: "#e6732c",
                backgroundColor: "rgba(230, 115, 44, 0.18)",
                borderWidth: 3,
                tension: 0.35,
                fill: true,
                pointRadius: 3
            }]
        },
        options: {
            plugins: {
                legend: { display: false }
            },
            scales: {
                x: { grid: { display: false } },
                y: { beginAtZero: false }
            }
        }
    });

    new Chart(document.getElementById("trafficChart"), {
        type: "doughnut",
        data: {
            labels: ["Google", "Direct", "Social", "Referral"],
            datasets: [{
                data: [58, 22, 14, 6],
                backgroundColor: ["#fb923c", "#60a5fa", "#34d399", "#f87171"]
            }]
        },
        options: {
            plugins: {
                legend: {
                    position: "bottom",
                    labels: { boxWidth: 12 }
                }
            }
        }
    });

    new Chart(document.getElementById("categoryChart"), {
        type: "bar",
        data: {
            labels: ["Painting", "Sculpture", "Photography", "Events", "News"],
            datasets: [{
                label: "Reads",
                data: [3200, 2100, 1800, 2600, 1900],
                backgroundColor: ["#fdba74", "#93c5fd", "#86efac", "#fda4af", "#c4b5fd"],
                borderRadius: 8
            }]
        },
        options: {
            plugins: {
                legend: { display: false }
            },
            scales: {
                x: { grid: { display: false } },
                y: { beginAtZero: true }
            }
        }
    });
});
</script>
@endsection
