@php
    $isEdit = isset($blog);
    $titleValue = old('title', $isEdit ? $blog->title : '');
    $slugValue = old('slug', $isEdit ? $blog->slug : '');
    $categoryValue = old('blog_category_id', $isEdit ? $blog->blog_category_id : '');
    $shortDescriptionValue = old('short_description', $isEdit ? $blog->short_description : '');
    $seoTitleValue = old('seo_title', $isEdit ? $blog->seo_title : '');
    $metaDescriptionValue = old('meta_description', $isEdit ? $blog->meta_description : '');
    $statusValue = old('status', $isEdit ? $blog->status : 'draft');
    $contentValue = old('content', $isEdit ? $blog->content : '');
    $updatedByValue = old('updated_by', $isEdit ? ($blog->updated_by ?? '') : (Auth::guard('admin')->user()->name ?? ''));
    $hasImage = $isEdit && !empty($blog->image);
    $imageUrl = $hasImage ? asset('uploads/blogs/' . $blog->image) : '';
@endphp

<div class="row g-3">
    <div class="col-md-8">
        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
        <input
            type="text"
            name="title"
            id="title"
            class="form-control @error('title') is-invalid @enderror"
            value="{{ $titleValue }}"
            required
        >
        @error('title')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-4">
        <label for="slug" class="form-label">Slug</label>
        <input
            type="text"
            name="slug"
            id="slug"
            class="form-control @error('slug') is-invalid @enderror"
            value="{{ $slugValue }}"
        >
        @error('slug')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label for="blog_category_id" class="form-label">Blog Category <span class="text-danger">*</span></label>
        <select
            name="blog_category_id"
            id="blog_category_id"
            class="form-select @error('blog_category_id') is-invalid @enderror"
            required
        >
            <option value="">-- Select Blog Category --</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}" {{ (string) $categoryValue === (string) $category->id ? 'selected' : '' }}>
                    {{ $category->name }}
                </option>
            @endforeach
        </select>
        @error('blog_category_id')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
        <select
            name="status"
            id="status"
            class="form-select @error('status') is-invalid @enderror"
            required
        >
            <option value="draft" {{ $statusValue === 'draft' ? 'selected' : '' }}>Draft</option>
            <option value="published" {{ $statusValue === 'published' ? 'selected' : '' }}>Published</option>
        </select>
        @error('status')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-12">
        <label for="short_description" class="form-label">Short Description <span class="text-danger">*</span></label>
        <textarea
            name="short_description"
            id="short_description"
            class="form-control @error('short_description') is-invalid @enderror"
            rows="3"
            required
        >{{ $shortDescriptionValue }}</textarea>
        @error('short_description')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label for="seo_title" class="form-label">SEO Title</label>
        <input
            type="text"
            name="seo_title"
            id="seo_title"
            class="form-control @error('seo_title') is-invalid @enderror"
            value="{{ $seoTitleValue }}"
        >
        @error('seo_title')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label for="updated_by" class="form-label">Updated By</label>
        <input
            type="text"
            name="updated_by"
            id="updated_by"
            class="form-control"
            value="{{ $updatedByValue }}"
            placeholder="Admin name"
        >
    </div>

    <div class="col-12">
        <label for="meta_description" class="form-label">Meta Description</label>
        <textarea
            name="meta_description"
            id="meta_description"
            class="form-control @error('meta_description') is-invalid @enderror"
            rows="3"
        >{{ $metaDescriptionValue }}</textarea>
        @error('meta_description')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label for="image" class="form-label">Image</label>
        <input
            type="file"
            name="image"
            id="image"
            class="form-control @error('image') is-invalid @enderror"
            accept="image/*"
        >
        @error('image')
            <div class="invalid-feedback d-block">{{ $message }}</div>
        @enderror
    </div>

    <div class="col-md-6">
        <label class="form-label">Image Preview</label>
        <div class="border rounded bg-light p-2 text-center" style="min-height: 150px;">
            <img
                id="imagePreview"
                src="{{ $imageUrl }}"
                data-initial-src="{{ $imageUrl }}"
                data-has-initial="{{ $hasImage ? '1' : '0' }}"
                alt="Blog image preview"
                class="img-fluid rounded"
                style="max-height: 180px; {{ $hasImage ? '' : 'display:none;' }}"
            >
            <p id="imagePlaceholder" class="text-muted mb-0 {{ $hasImage ? 'd-none' : '' }}">No image selected</p>
        </div>
    </div>

    <div class="col-12">
        <label for="blogContent" class="form-label">Content <span class="text-danger">*</span></label>
        <textarea
            name="content"
            id="blogContent"
            class="form-control @error('content') is-invalid @enderror"
            rows="9"
            required
        >{{ $contentValue }}</textarea>
        @error('content')
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
</div>

<div class="mt-4 d-flex gap-2 flex-wrap">
    <button type="submit" class="btn btn-primary px-4">
        {{ $isEdit ? 'Update Blog' : 'Create Blog' }}
    </button>
    <a href="{{ route('admin.blogs.index') }}" class="btn btn-outline-secondary px-4">Cancel</a>
</div>

@once
    @push('scripts')
        <script>
            (function () {
                var titleInput = document.getElementById('title');
                var slugInput = document.getElementById('slug');
                var imageInput = document.getElementById('image');
                var imagePreview = document.getElementById('imagePreview');
                var imagePlaceholder = document.getElementById('imagePlaceholder');

                if (titleInput && slugInput) {
                    titleInput.addEventListener('blur', function () {
                        if (slugInput.value.trim() !== '') {
                            return;
                        }

                        var generatedSlug = titleInput.value
                            .toLowerCase()
                            .trim()
                            .replace(/[^a-z0-9\s-]/g, '')
                            .replace(/\s+/g, '-')
                            .replace(/-+/g, '-')
                            .replace(/^-+|-+$/g, '');

                        slugInput.value = generatedSlug;
                    });
                }

                if (imageInput && imagePreview) {
                    imageInput.addEventListener('change', function (event) {
                        var file = event.target.files && event.target.files[0] ? event.target.files[0] : null;
                        var hasInitial = imagePreview.getAttribute('data-has-initial') === '1';
                        var initialSrc = imagePreview.getAttribute('data-initial-src') || '';

                        if (!file) {
                            if (hasInitial && initialSrc !== '') {
                                imagePreview.src = initialSrc;
                                imagePreview.style.display = 'inline-block';
                                if (imagePlaceholder) {
                                    imagePlaceholder.classList.add('d-none');
                                }
                            } else {
                                imagePreview.src = '';
                                imagePreview.style.display = 'none';
                                if (imagePlaceholder) {
                                    imagePlaceholder.classList.remove('d-none');
                                }
                            }
                            return;
                        }

                        var reader = new FileReader();
                        reader.onload = function (e) {
                            imagePreview.src = e.target.result;
                            imagePreview.style.display = 'inline-block';
                            if (imagePlaceholder) {
                                imagePlaceholder.classList.add('d-none');
                            }
                        };
                        reader.readAsDataURL(file);
                    });
                }
            })();
        </script>
    @endpush
@endonce
