@extends('admin.layout')

@section('content')
<style>
.blog-category-page .page-head {
    padding: 1.05rem 1.2rem;
    border-radius: 16px;
    border: 1px solid #f0d4bf;
    background: linear-gradient(140deg, #fff9f4 0%, #ffffff 68%, #fff3e8 100%);
    box-shadow: 0 14px 30px rgba(15, 23, 42, 0.08);
}

.blog-category-page .title {
    margin: 0;
    font-size: 1.45rem;
    font-weight: 700;
    color: #1f2937;
}

.blog-category-page .kicker {
    margin: 0 0 .2rem 0;
    font-size: .72rem;
    font-weight: 700;
    letter-spacing: .11em;
    text-transform: uppercase;
    color: #d97706;
}

.blog-category-page .card-shell {
    border: 1px solid #e6ebf3;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 20px 42px rgba(15, 23, 42, 0.08);
    background: #fff;
}

.blog-category-page .card-head {
    padding: .95rem 1.1rem;
    background: #fbfcff;
    border-bottom: 1px solid #edf1f7;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.blog-category-page .add-btn {
    border: 0;
    border-radius: 10px;
    padding: .58rem .9rem;
    font-size: .84rem;
    font-weight: 600;
    color: #fff;
    background: linear-gradient(135deg, #e6732c 0%, #f59a4f 100%);
    text-decoration: none;
}

.blog-category-page .add-btn:hover {
    color: #fff;
    background: linear-gradient(135deg, #ca5f1e 0%, #e6732c 100%);
}

.blog-category-page .table-wrap {
    overflow-x: auto;
}

.blog-category-page table {
    width: 100%;
    border-collapse: collapse;
    min-width: 640px;
}

.blog-category-page thead th {
    background: #f5f8fd;
    color: #52607a;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .06em;
    padding: .85rem 1rem;
    border-bottom: 1px solid #e7edf6;
}

.blog-category-page tbody td {
    padding: .9rem 1rem;
    border-bottom: 1px solid #edf1f7;
    vertical-align: middle;
    color: #1f2937;
}

.blog-category-page tbody tr:hover {
    background: #fbfdff;
}

.blog-category-page .btn-edit {
    border: 0;
    border-radius: 8px;
    padding: .38rem .7rem;
    font-size: .75rem;
    font-weight: 600;
    color: #fff;
    text-decoration: none;
    background: #2563eb;
}

.blog-category-page .btn-edit:hover {
    color: #fff;
    background: #1d4ed8;
}

.blog-category-page .pagination-wrap {
    padding: .95rem 1.1rem 1.1rem;
}
</style>

<div class="blog-category-page">
    <div class="page-head mb-4">
        <p class="kicker">Admin Panel</p>
        <h2 class="title">Blog Categories</h2>
    </div>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="card-shell">
        <div class="card-head">
            <strong style="color:#334155;">All Blog Categories</strong>
            <a href="{{ route('admin.blog-categories.create') }}" class="add-btn">+ Add Category</a>
        </div>

        <div class="table-wrap">
            <table>
                <thead>
                    <tr>
                        <th style="width: 90px;">S.NO.</th>
                        <th>Category Name</th>
                        <th>Slug</th>
                        <th style="width: 130px;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($categories as $category)
                    <tr>
                        <td>{{ $categories->firstItem() + $loop->index }}</td>
                        <td>{{ $category->name }}</td>
                        <td>{{ $category->slug }}</td>
                        <td>
                            <a href="{{ route('admin.blog-categories.edit', $category->id) }}" class="btn-edit">Edit</a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">No categories found</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="pagination-wrap d-flex justify-content-center">
            {{ $categories->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>
@endsection
