@extends('admin.layout')

@section('title', 'Artist Bulk Upload')

@section('content')
<style>
.artist-bulk-page {
    --artist-accent: #e6732c;
    --artist-border: #e4e8f1;
    --artist-text: #1f2937;
    --artist-muted: #6b7280;
}

.artist-bulk-page .page-head {
    padding: 1.1rem 1.35rem;
    border-radius: 16px;
    background: linear-gradient(140deg, #fff7ef 0%, #ffffff 65%, #fff4ea 100%);
    border: 1px solid #f3d4ba;
    box-shadow: 0 14px 28px rgba(15, 23, 42, 0.08);
}

.artist-bulk-page .kicker {
    margin: 0 0 .25rem 0;
    font-size: .74rem;
    text-transform: uppercase;
    letter-spacing: .11em;
    color: var(--artist-accent);
    font-weight: 700;
}

.artist-bulk-page .page-title {
    margin: 0;
    font-size: 1.7rem;
    color: var(--artist-text);
    font-weight: 700;
}

.artist-bulk-page .card-shell {
    border-radius: 18px;
    border: 1px solid var(--artist-border);
    background: #fff;
    box-shadow: 0 24px 52px rgba(15, 23, 42, 0.08);
    overflow: hidden;
}

.artist-bulk-page .card-head {
    padding: 1rem 1.2rem;
    border-bottom: 1px solid #edf1f7;
    background: #fbfcff;
    display: flex;
    align-items: center;
    justify-content: space-between;
    gap: 12px;
}

.artist-bulk-page .btn-pill {
    border-radius: 10px;
    padding: .58rem .95rem;
    font-weight: 600;
    font-size: .84rem;
    text-decoration: none;
}

.artist-bulk-page .stats-grid {
    display: grid;
    grid-template-columns: repeat(4, minmax(0, 1fr));
    gap: 12px;
}

.artist-bulk-page .stat-card {
    border: 1px solid #eceff5;
    border-radius: 12px;
    padding: .8rem .9rem;
}

.artist-bulk-page .stat-label {
    color: var(--artist-muted);
    font-size: .78rem;
    margin-bottom: .2rem;
}

.artist-bulk-page .stat-value {
    font-size: 1.45rem;
    font-weight: 700;
    color: var(--artist-text);
}

.artist-bulk-page .table-wrap {
    overflow-x: auto;
}

.artist-bulk-page table {
    width: 100%;
    border-collapse: collapse;
    min-width: 940px;
}

.artist-bulk-page thead th {
    padding: .85rem 1rem;
    font-size: .75rem;
    letter-spacing: .06em;
    text-transform: uppercase;
    color: #5a6880;
    background: #f5f8fd;
    border-bottom: 1px solid #e7edf6;
}

.artist-bulk-page tbody td {
    padding: .95rem 1rem;
    border-bottom: 1px solid #edf1f7;
    color: var(--artist-text);
    vertical-align: middle;
}

@media (max-width: 992px) {
    .artist-bulk-page .stats-grid {
        grid-template-columns: repeat(2, minmax(0, 1fr));
    }
}

@media (max-width: 768px) {
    .artist-bulk-page .card-head {
        flex-direction: column;
        align-items: stretch;
    }

    .artist-bulk-page .stats-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="artist-bulk-page">
    <div class="page-head mb-4 d-flex flex-wrap justify-content-between align-items-start gap-3">
        <div>
            <p class="kicker">Admin Panel</p>
            <h2 class="page-title">Artist Bulk Upload</h2>
        </div>

        <div class="d-flex flex-wrap gap-2">
            <a href="{{ route('admin.artists.index') }}" class="btn btn-outline-secondary btn-pill">Back to Artists</a>
            <a href="{{ route('admin.artists.bulk-upload.template') }}" class="btn btn-warning text-white btn-pill">Download Sample</a>
        </div>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0 ps-3">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="card-shell mb-4">
        <div class="card-head">
            <strong style="color:#334155;">Upload File</strong>
        </div>
        <div class="p-4">
            <form method="POST" action="{{ route('admin.artists.bulk-upload') }}" enctype="multipart/form-data">
                @csrf
                <div class="row g-3 align-items-end">
                    <div class="col-lg-8">
                        <label for="bulk_file" class="form-label fw-semibold">XLSX or CSV File</label>
                        <input
                            type="file"
                            id="bulk_file"
                            name="file"
                            class="form-control"
                            accept=".xlsx,.csv"
                            required
                        >
                    </div>
                    <div class="col-lg-4">
                        <button type="submit" class="btn btn-primary w-100 btn-pill">Upload & Process</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    @if (!empty($summary))
        <div class="card-shell mb-4">
            <div class="card-head">
                <strong style="color:#334155;">Result Summary</strong>
                @if (!empty($rowErrors) && !empty($errorToken))
                    <a href="{{ route('admin.artists.bulk-upload.errors', $errorToken) }}" class="btn btn-outline-danger btn-pill">
                        Download Error Excel
                    </a>
                @endif
            </div>

            <div class="p-4">
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-label">Total Rows</div>
                        <div class="stat-value">{{ $summary['total_rows'] ?? 0 }}</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-label">Created</div>
                        <div class="stat-value text-success">{{ $summary['created'] ?? 0 }}</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-label">Updated</div>
                        <div class="stat-value text-primary">{{ $summary['updated'] ?? 0 }}</div>
                    </div>
                    <div class="stat-card">
                        <div class="stat-label">Failed</div>
                        <div class="stat-value text-danger">{{ $summary['failed'] ?? 0 }}</div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (!empty($rowErrors))
        <div class="card-shell">
            <div class="card-head">
                <strong style="color:#334155;">Failed Rows</strong>
            </div>
            <div class="table-wrap">
                <table>
                    <thead>
                        <tr>
                            <th>Row</th>
                            <th>Name</th>
                            <th>Status</th>
                            <th>Email</th>
                            <th>Username</th>
                            <th>Reason</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($rowErrors as $errorRow)
                            <tr>
                                <td>{{ $errorRow['row'] ?? '-' }}</td>
                                <td>{{ $errorRow['name'] ?? '-' }}</td>
                                <td>{{ $errorRow['status'] ?? '-' }}</td>
                                <td>{{ $errorRow['email'] ?? '-' }}</td>
                                <td>{{ $errorRow['username'] ?? '-' }}</td>
                                <td class="text-danger">{{ $errorRow['reason'] ?? '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>
@endsection
