@extends('admin.layout')

@section('title', 'Edit About Page')

@section('content')
<div class="container py-4">

    <h2 class="fw-bold mb-4">Edit About Page</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('admin.about.update') }}" method="POST" enctype="multipart/form-data">
        @csrf

        {{-- ================= PAGE HEADER ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Page Header</div>
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">Page Title</label>
                    <input type="text" name="page_title" value="{{ $about->page_title }}" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Breadcrumb Text</label>
                    <input type="text" name="breadcrumb_text" value="{{ $about->breadcrumb_text }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Banner Image</label>
                    <input type="file" name="banner_image" class="form-control">
                    @if($about->banner_image)
                        <img src="{{ asset('uploads/about/'.$about->banner_image) }}"
                             class="mt-2 rounded"
                             width="180">
                    @endif
                </div>

            </div>
        </div>

        {{-- ================= WELCOME SECTION ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Welcome Section</div>
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">Title</label>
                    <input type="text" name="welcome_title" value="{{ $about->welcome_title }}" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Subtitle</label>
                    <input type="text" name="welcome_subtitle" value="{{ $about->welcome_subtitle }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea name="welcome_description" rows="4" class="form-control">{{ $about->welcome_description }}</textarea>
                </div>

            </div>
        </div>

        {{-- ================= STORY SECTION ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Our Story</div>
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">Title</label>
                    <input type="text" name="story_title" value="{{ $about->story_title }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea name="story_description" rows="4" class="form-control">{{ $about->story_description }}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Story Image</label>
                    <input type="file" name="story_image" class="form-control">
                    @if($about->story_image)
                        <img src="{{ asset('uploads/about/'.$about->story_image) }}"
                             class="mt-2 rounded"
                             width="180">
                    @endif
                </div>

            </div>
        </div>

        {{-- ================= WHY CHOOSE US ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Why Choose Us</div>
            <div class="card-body">

                @for($i = 1; $i <= 3; $i++)
                    <div class="border rounded p-3 mb-3">
                        <div class="mb-2">
                            <label class="form-label">Title {{ $i }}</label>
                            <input type="text"
                                   name="why_{{ $i }}_title"
                                   value="{{ $about->{'why_'.$i.'_title'} }}"
                                   class="form-control">
                        </div>

                        <div>
                            <label class="form-label">Description {{ $i }}</label>
                            <textarea name="why_{{ $i }}_desc"
                                      rows="2"
                                      class="form-control">{{ $about->{'why_'.$i.'_desc'} }}</textarea>
                        </div>
                    </div>
                @endfor

            </div>
        </div>

        {{-- ================= COMMITMENT ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Our Commitment</div>
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">Title</label>
                    <input type="text" name="commitment_title" value="{{ $about->commitment_title }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Description</label>
                    <textarea name="commitment_description" rows="3" class="form-control">{{ $about->commitment_description }}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Image</label>
                    <input type="file" name="commitment_image" class="form-control">
                    @if($about->commitment_image)
                        <img src="{{ asset('uploads/about/'.$about->commitment_image) }}"
                             class="mt-2 rounded"
                             width="180">
                    @endif
                </div>

            </div>
        </div>

        {{-- ================= CTA ================= --}}
        <div class="card mb-4">
            <div class="card-header fw-bold">Call To Action</div>
            <div class="card-body">

                <div class="mb-3">
                    <label class="form-label">CTA Text</label>
                    <input type="text" name="cta_text" value="{{ $about->cta_text }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Button Text</label>
                    <input type="text" name="cta_button_text" value="{{ $about->cta_button_text }}" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label">Button Link</label>
                    <input type="text" name="cta_button_link" value="{{ $about->cta_button_link }}" class="form-control">
                </div>

            </div>
        </div>

        {{-- ================= SAVE ================= --}}
        <button class="btn btn-success px-4">
            Save Changes
        </button>

    </form>

</div>
@endsection
