import { objectSpread2 as _objectSpread2 } from '../_virtual/_rollupPluginBabelHelpers.mjs';
import { PRODUCTION_DOMAIN, DEVELOPMENT_DOMAIN } from '../config/endpoints.mjs';
import { ProducerMiddleware } from '../middleware/producer-middleware.mjs';
import { v4 } from '../helpers/uuid.mjs';
import { HttpProducer } from './http-producer.mjs';
import { LogProducer } from './log-producer.mjs';

class Monorail {
  static createLogProducer(config) {
    return new Monorail(new LogProducer(config.debugMode), config.middleware || []);
  }
  static createHttpProducerWithEndpoint(edgeEndpoint, middleware = []) {
    return new Monorail(HttpProducer.withEndpoint(edgeEndpoint), middleware);
  }
  static createHttpProducer(config) {
    return new Monorail(config.production ? new HttpProducer(PRODUCTION_DOMAIN, config.options) : new HttpProducer(DEVELOPMENT_DOMAIN, config.options), config.middleware || []);
  }
  static buildMiddlewareChain(middleware, index = 0) {
    if (index === middleware.length) {
      return this.identityFn;
    }
    return event => middleware[index].do(event, this.buildMiddlewareChain(middleware, index + 1));
  }
  constructor(producer, middleware) {
    this.producer = producer;
    this.middleware = middleware;
    this.executeChain = Monorail.buildMiddlewareChain(this.middleware.concat(new ProducerMiddleware(producer)));
  }
  produce(monorailEvent) {
    monorailEvent.metadata = _objectSpread2({
      eventCreatedAtMs: Date.now(),
      clientMessageId: v4()
    }, monorailEvent.metadata);
    return this.executeChain(monorailEvent);
  }
  produceBatch(monorailBatchEvent) {
    return this.executeChain(monorailBatchEvent);
  }
}

export { Monorail };
