class LogProducer {
  static printWelcomeMessage(sendToConsole) {
    // eslint-disable-next-line no-console
    console.log(`%c👋 from Monorail%c\n\n` + `We've noticed that you're${sendToConsole ? '' : ' not'} ` + `running in debug mode. ` + `As such, we will ${sendToConsole ? 'produce' : 'not produce'} ` + `Monorail events to the console. ` + `\n\nIf you want Monorail events to ${sendToConsole ? 'stop' : 'start'} ` + `appearing here, %cset debugMode=${(!sendToConsole).toString()}%c, ` + `for the Monorail Log Producer in your code.`, 'font-size: large;', 'font-size: normal;', 'font-weight: bold;', 'font-weight: normal;');
  }
  constructor(sendToConsole) {
    this.sendToConsole = sendToConsole;
    if (sendToConsole) {
      LogProducer.printWelcomeMessage(sendToConsole);
    }
  }
  async produce(monorailEvent) {
    if (this.sendToConsole) {
      // eslint-disable-next-line no-console
      console.log('Monorail event produced', monorailEvent);
    }
    return new Promise(resolve => {
      resolve(monorailEvent);
    });
  }
  produceBatch(monorailBatchEvent) {
    if (this.sendToConsole) {
      // eslint-disable-next-line no-console
      console.log('Monorail Batch event produced', monorailBatchEvent);
    }
    return new Promise(resolve => {
      resolve(monorailBatchEvent);
    });
  }
}

export { LogProducer };
