import { isCompositeMonorailEvent } from '../events/events.mjs';

class ProducerMiddleware {
  constructor(producer) {
    this.producer = producer;
  }
  do(event, proceed) {
    if (isCompositeMonorailEvent(event)) {
      return this.producer.produce(event);
    } else {
      return this.producer.produceBatch(event);
    }
  }
}

export { ProducerMiddleware };
