// This was using uuid package, but to reduce bundle size we'll fallback to Math.random instead
//
// The value is used to deduplicate messages and so does not need to be cryptographically secure
function v4() {
  if (typeof crypto !== 'undefined' && crypto && typeof crypto.randomUUID === 'function') {
    return crypto.randomUUID();
  }
  const uuid = new Array(36);
  for (let i = 0; i < 36; i++) {
    uuid[i] = Math.floor(Math.random() * 16);
  }

  // set bits 12-15 of time-high-and-version to 0100
  uuid[14] = 4;

  /* eslint-disable no-multi-assign */

  // set bit 6 of clock-seq-and-reserved to zero
  uuid[19] = uuid[19] &= -5;

  // set bit 7 of clock-seq-and-reserved to one
  uuid[19] = uuid[19] |= 1 << 3;
  uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';

  /* eslint-enable no-multi-assign */

  return uuid.map(x => x.toString(16)).join('');
}

export { v4 };
