<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('form_medium', function (Blueprint $table) {
        $table->engine = 'InnoDB';

        $table->unsignedBigInteger('form_id');
        $table->unsignedBigInteger('medium_id');

        $table->primary(['form_id', 'medium_id']);

        $table->foreign('form_id')
              ->references('id')
              ->on('forms')
              ->onDelete('cascade');

        // ✅ CORRECT TABLE NAME: mediums
        $table->foreign('medium_id')
              ->references('id')
              ->on('mediums')
              ->onDelete('cascade');
    });
}

public function down()
{
    Schema::dropIfExists('form_medium');
}




    /**
     * Reverse the migrations.
     */
   
};
