<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
  public function up()
{
    Schema::create('category_painting', function (Blueprint $table) {
        $table->id();
        $table->foreignId('painting_id')->constrained()->cascadeOnDelete();
        $table->foreignId('category_id')->constrained()->cascadeOnDelete();
        $table->unique(['painting_id', 'category_id']);
    });
}

public function down()
{
    Schema::dropIfExists('category_painting');
}

};
