<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\BlogCategory;
use Illuminate\Http\Request;

class FrontBlogController extends Controller
{
    /**
     * Show all blogs (View All)
     */
    public function index()
    {
        $blogs = Blog::where('status', 'published')
            ->latest()
            ->paginate(6);

        $categories = BlogCategory::orderBy('name')->get();

        return view('front.blogs.index', compact('blogs', 'categories'));
    }

    /**
     * Show blogs by category
     */
    public function category($slug)
    {
        $category = BlogCategory::where('slug', $slug)->firstOrFail();

        $blogs = Blog::where('status', 'published')
            ->where('blog_category_id', $category->id)
            ->latest()
            ->paginate(6);

        $categories = BlogCategory::orderBy('name')->get();

        return view('front.blogs.index', compact('blogs', 'categories', 'category'));
    }

    /**
     * Blog detail page
     */
    public function show($slug)
    {
        $blog = Blog::where('slug', $slug)
            ->where('status', 'published')
            ->firstOrFail();

        $recentBlogs = Blog::where('status', 'published')
            ->where('id', '!=', $blog->id)
            ->latest()
            ->take(5)
            ->get();

        return view('front.blogs.show', compact('blog', 'recentBlogs'));
    }
}
