<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Sculpture;

class SculptureController extends Controller
{
    public function index()
    {
        $sculptures = Sculpture::latest()->paginate(12);
        return view('front.sculptures.index', compact('sculptures'));
    }

    public function show($id)
    {
        $sculpture = Sculpture::findOrFail($id);
        return view('front.sculptures.show', compact('sculpture'));
    }
}
