<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\ArtworkType;
use App\Models\Painting;
use App\Models\Form;
use App\Models\Medium;
use Illuminate\Http\Request;

class ArtworkController extends Controller
{
    /**
     * Show all artwork types
     * URL: /artworks
     */
    public function index()
    {
        $artworks = ArtworkType::orderBy('name')->get();

        return view('front.artworks.index', compact('artworks'));
    }

    /**
     * Show paintings under a specific artwork type
     * URL: /artworks/{slug}
     */
    public function show($slug)
    {
        // ✅ Get artwork type
        $artwork = ArtworkType::where('slug', $slug)->firstOrFail();

        // ✅ Get paintings under this artwork type
        $paintings = Painting::where('artwork_type_id', $artwork->id)
            ->where('status', 'active')
            ->latest()
            ->paginate(12);

        // ✅ Filters (VERY IMPORTANT)
        $forms   = Form::orderBy('name')->get();
        $mediums = Medium::orderBy('name')->get();

        return view('front.artworks.show', compact(
            'artwork',
            'paintings',
            'forms',
            'mediums'
        ));
    }
}
