<?php

namespace App\Http\Controllers;

use App\Models\Painting;

class ArtworkController extends Controller
{
    public function show($slug)
    {
        $paintingQuery = Painting::with(['artist', 'categories', 'medium', 'form']);

        $painting = (clone $paintingQuery)
            ->where('slug', $slug)
            ->first();

        if (!$painting && is_numeric($slug)) {
            $painting = $paintingQuery->find($slug);
        }

        if (!$painting) {
            abort(404);
        }

        return view('front.paintings.show', compact('painting'));
    }
}
