<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactSetting;

class ContactSettingController extends Controller
{
    public function edit()
    {
        $setting = ContactSetting::first();
        return view('admin.contact.settings', compact('setting'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'address'   => 'nullable|string',
            'phone'     => 'nullable|string',
            'email'     => 'nullable|email',
            'map_embed' => 'nullable|string',
        ]);

        ContactSetting::updateOrCreate(
            ['id' => 1],
            $data
        );

        return back()->with('success', 'Contact page updated successfully');
    }
}

