<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ArtAdvisory;
use Illuminate\Support\Facades\Storage;

class ArtAdvisoryController extends Controller
{
    public function edit()
    {
        $advisory = ArtAdvisory::first();
        return view('admin.art-advisory.edit', compact('advisory'));
    }

    public function update(Request $request)
    {
        $data = $request->validate([
            'content' => 'nullable',
            'image'   => 'nullable|image'
        ]);

        $advisory = ArtAdvisory::first() ?? new ArtAdvisory();

        if ($request->hasFile('image')) {
            if ($advisory->image) {
                Storage::disk('public')->delete($advisory->image);
            }

            $data['image'] = $request->file('image')
                ->store('art-advisory', 'public');
        }

        $advisory->fill($data)->save();

        return back()->with('success', 'Art Advisory updated successfully');
    }
}

