<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AboutCreativitySection;

class AboutCreativityController extends Controller
{
    /**
     * Show edit page (single record CMS)
     */
    public function index()
    {
        $section = AboutCreativitySection::first();
        return view('admin.about_creativity.index', compact('section'));
    }

    /**
     * Store or update section
     */
    public function store(Request $request)
    {
        $request->validate([
            'title'          => 'required|string|max:255',
            'description_1'  => 'required',
            'description_2'  => 'nullable',
            'media_type'     => 'required|in:image,video',
            'media_url'      => 'required',
            'button_text'    => 'required|string|max:100',
            'button_link'    => 'required|string|max:255',
        ]);

        AboutCreativitySection::updateOrCreate(
            ['id' => 1],   // 👈 single row CMS
            [
                'title'         => $request->title,
                'description_1' => $request->description_1,
                'description_2' => $request->description_2,
                'media_type'    => $request->media_type,
                'media_url'     => $request->media_url,
                'button_text'   => $request->button_text,
                'button_link'   => $request->button_link,
                'status'        => 'active',
            ]
        );

        return redirect()->back()->with('success', 'About Creativity section updated successfully.');
    }
}
