<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ArtworkBulkErrorsExport implements FromCollection, WithHeadings
{
    public function __construct(protected array $errors)
    {
    }

    public function collection(): Collection
    {
        return collect($this->errors)->map(function (array $error) {
            return [
                'row' => $error['row'] ?? '',
                'title' => $error['title'] ?? '',
                'painting_code' => $error['painting_code'] ?? '',
                'artist_name' => $error['artist_name'] ?? '',
                'status' => $error['status'] ?? '',
                'reason' => $error['reason'] ?? 'Unknown error',
            ];
        });
    }

    public function headings(): array
    {
        return [
            'row',
            'title',
            'painting_code',
            'artist_name',
            'status',
            'reason',
        ];
    }
}
